# **Blocked Lists and Allowed Lists**

- **Definition:** Security techniques used to control access to resources.

## **1. Blocked Lists (Blacklists)**

- **Function:** Deny access to resources for entities found on the list.
- **Entities that can be blocked:**
    - IP addresses
    - Ranges of IP addresses
    - Applications
    - Domains
    - URLs
- **Logic:** Allows all traffic _except_ what is explicitly denied.
- **Example:** Blocking IP address 209.165.200.230 blocks all traffic to/from that address.

## **2. Allowed Lists (Whitelists)**

- **Function:** Deny all traffic _except_ what is explicitly permitted (listed on the allowed list).
- **Logic:** Denies all traffic that is not explicitly permitted.

## **3. Implementation and Types**

- **Support:** Many security solutions (IPSs, firewalls, email security products, etc.) support both blocked lists and allowed lists.
- **Manual Creation:** Lists can be created manually.
- **Dynamic Blocked List Databases:**
    - Contain known malicious entities (domains, IP addresses).
    - Help keep up with the constant proliferation of new threats.
    - Based on security intelligence services.
- **Static Lists:** Dynamic databases can be supplemented with static blocked lists and allowed lists.
- **Overriding:** Allowed lists can override blocked lists (e.g., in Cisco Secure Firewall).
- **Other Types:**
    - Email security products: Blocked/allowed lists of email addresses.
    - Web security products: Blocked/allowed lists of URLs.

## **4. Application Blocked Lists and Allowed Lists**

- **Function:** Control which programs are allowed to run on an endpoint.
- **Identification Methods:**
    - Certificates
    - File hash values
- **Example (Windows):**
    - Local Group Policy Editor (gpedit.msc) can be used to allow only specified programs to run.
    - Navigate to User Configuration > Administrative Templates > System > Run only specified Windows applications.
    - Enable the setting and add applications to the allowed list.
    - Users will receive an error message if they try to run an application not on the list.
- **Benefits:** Reduces the ability of exploit kits to deploy malicious payloads.
- **Limitations:**
    - May not stop malware payloads that run in memory.
    - Example: Bedep malware injects code into running processes (e.g., browsers).
    - Malware can persist by inserting code into hidden Windows registry keys.